package gov.va.med.mhv.sm.admin.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.sm.admin.model.TriageGroup;

@Repository
public interface TriageGroupRepository extends JpaRepository<TriageGroup, Long>{
	
	@Query("select triageGroup from TriageGroup triageGroup LEFT JOIN FETCH triageGroup.relations where upper(triageGroup.name) = upper(:triageGroupName)")
	TriageGroup findTriageGroupByName(@Param("triageGroupName") String triageGroupName);
	
	
	@Query("select distinct tg from TriageGroup tg,TriageRelation tr,PatientTriageMap ptm where tg.id=tr.triageGroupId " +
			"and tr.id=ptm.relationId and ptm.patientId=:patientId and tg.active=1 and tr.active=1 order by upper(tg.name)" )
	List<TriageGroup> getTriageGroupsForPatient(@Param("patientId") Long patientId);
	
	
	@Query("select distinct tg from TriageGroup tg,TriageRelation tr,PatientTriageMap ptm where tg.id=tr.triageGroupId " +
				"and tr.id=ptm.relationId and ptm.patientId=:patientId and tg.vistaDiv=:stationNumber and tg.active=1 and tr.active=1 order by upper(tg.name)" )
	List<TriageGroup> getTriageGroupsForPatientByStation(@Param("patientId") Long userPatientId,@Param("stationNumber") String stationNumber);

	
	@Query("select triageGroup from TriageGroup triageGroup LEFT JOIN FETCH triageGroup.relations where upper(triageGroup.name) = upper(:triageGroupName) and triageGroup.active=1")
	TriageGroup findActiveTriageGroupByName(@Param("triageGroupName") String triageGroupName);
	
	@Query("select tg from TriageGroup tg where tg.active=1 order by upper(tg.name)" )
	List<TriageGroup> getTriageGroups();
	
	@Query("select tg from TriageGroup tg where tg.vistaDiv=:stationNumber and tg.active = 1 order by upper(tg.name)" )
	List<TriageGroup> getTriageGroupsForStation(@Param("stationNumber") String stationNumber);
	
}